# 画面設計書 12-Region Plugin

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）におけるRegion Plugin画面（Page 20）の設計書である。QUASTOリージョンプラグインの動作確認・デモを行うための通常ページについて、その構成、機能、データフローを定義する。

### 本画面の処理概要

本画面は、QUASTOリージョンプラグインの機能をデモンストレーションするための画面である。APEXアプリケーション、ページ、ルールを選択し、QUASTOルール検証結果をリアルタイムで表示する。

**業務上の目的・背景**：QUASTOはOracle APEXアプリケーションの品質チェックルールを定義・実行するツールである。本画面では、開発者がQUASTOリージョンプラグインを自身のアプリケーションに組み込む前に、プラグインの動作を確認できる。また、特定のAPEXアプリケーション/ページに対してルールを実行し、違反オブジェクトを即座に確認することができる。これにより、開発段階での品質管理が容易になる。

**画面へのアクセス方法**：ナビゲーションメニューから「Region Plugin」を選択してアクセスする。Dashboard画面またはRules画面からもナビゲーションメニュー経由でアクセス可能。

**主要な操作・処理内容**：
1. Client Name（クライアント名）の選択（All または特定のクライアント）
2. Rule Selection（ルール番号）の選択（All または特定のルール）
3. Application（アプリケーションID）の選択（All または特定のAPEXアプリ）
4. Page（ページID）の選択（All または特定のページ）
5. 選択条件に基づいてQUASTOルールが実行され、違反オブジェクトがテーブル形式で表示される

**画面遷移**：
- 遷移元：Dashboard画面（Page 1）、Rules画面（Page 6）のナビゲーションメニュー
- 遷移先：Dashboard画面、Rules画面へのナビゲーションメニュー経由遷移

**権限による表示制御**：本画面はログイン認証が必要（p_protection_level=>'C'）。特定のロールによる表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 単一ルール実行 | 主機能 | 選択したルール番号とクライアント名でAPEXルールを実行 |
| 24 | APEXルール実行 | 主機能 | APEXアプリケーション/ページを対象としたルールを実行し結果を表示 |
| 3 | 全ルール実行 | 補助機能 | ルール未選択時に指定クライアントの全ルールを実行 |

## 画面種別

通常ページ（デモ・検証）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| Page ID | 20 |
| Page Alias | REGION-PLUGIN |
| Page Mode | 通常（Normal） |
| URL形式 | `f?p=141:20:&SESSION.` |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 表示タイプ | 説明 |
|--------|--------|----------|------|------------|------|
| Client Name | P20_CLIENT_NAME | VARCHAR2 | No | Select List | ルールのクライアント名を選択（All: 全クライアント） |
| Rule Selection | P20_RULE_SELECTION | VARCHAR2 | No | Select List | 実行するルール番号を選択（All: 全ルール） |
| Application | P20_APP_ID | NUMBER | No | Select List | 検証対象のAPEXアプリケーションIDを選択（All: 全アプリ） |
| Page | P20_APP_PAGE_ID | NUMBER | No | Select List | 検証対象のAPEXページIDを選択（All: 全ページ） |

## 表示項目

### QUASTO Region Plugin説明リージョン

HTMLコンテンツで構成され、以下の情報を表示：

| セクション | 内容 |
|-----------|------|
| ヘッダー | Sample Page to demonstrate the functionality of the QUASTO Region Plugin |
| Usage | 使用手順（3ステップ）の説明 |
| Note | 選択項目の組み合わせに関する注意事項 |
| How to install | プラグインのインストール方法 |
| How to Implement | アプリケーションへの組み込み方法 |
| How to use | Global Pageでの使用方法 |

### QUASTO Region Plugin Demoリージョン

QUASTOリージョンプラグイン（PLUGIN_QUASTO_REGION）による動的コンテンツ：

| 列名 | 説明 |
|------|------|
| # | 行番号 |
| Error Level | エラーレベル（Warning/Error等） |
| Rule Number | 違反したルール番号 |
| Rule Name | 違反したルール名 |
| Object Type | 違反オブジェクトのタイプ |
| Object Name | 違反オブジェクト名 |
| Details | 違反詳細情報 |

## イベント仕様

### 1-Client Name選択変更

**トリガー**：P20_CLIENT_NAMEの値変更時

**処理フロー**：
1. フォームをサブミット（attribute_01=>'SUBMIT'）
2. ページがリロードされ、選択したClient Nameに基づいてRule Selectionリストが更新
3. QUASTOプラグインリージョンが再描画

**データの流れ**：
```
[P20_CLIENT_NAME変更]
    |
    v
[Page Submit]
    |
    v
[Rule Selection LOV更新]
    |
    └─ SELECT from qa_rules WHERE qaru_client_name = :P20_CLIENT_NAME
```

### 2-Rule Selection選択変更

**トリガー**：P20_RULE_SELECTIONの値変更時

**処理フロー**：
1. フォームをサブミット
2. QUASTOプラグインリージョンが選択ルールで再実行

### 3-Application選択変更

**トリガー**：P20_APP_IDの値変更時

**処理フロー**：
1. フォームをサブミット
2. Page（P20_APP_PAGE_ID）リストがカスケード更新
3. QUASTOプラグインリージョンが選択アプリで再実行

### 4-Page選択変更

**トリガー**：P20_APP_PAGE_IDの値変更時

**処理フロー**：
1. フォームをサブミット
2. QUASTOプラグインリージョンが選択ページで再実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータ参照のみで更新は行わない |

### データ参照元

| ソース | 用途 |
|--------|------|
| QA_RULES | ルール定義、Client Name/Rule Selection LOV |
| APEX_APPLICATIONS | Application LOV |
| APEX_APPLICATION_PAGES | Page LOV |
| 各種APEXメタデータビュー | ルール実行時の検証対象 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| なし | - | - | 本画面では特定のメッセージは定義されていない |

## 例外処理

| 例外パターン | 発生条件 | 画面の挙動 |
|-------------|---------|------------|
| ルール実行エラー | QA_RULESのSQL実行時にエラー発生 | qa_logger_pkgにログ記録、例外は再スロー |
| アクティブルールなし | 選択条件に一致するアクティブルールが存在しない | 空のテーブルを表示 |
| APEXメタデータアクセスエラー | APEX_APPLICATION_PAGES等へのアクセス権限不足 | ORA-エラー表示 |

## 備考

- プラグインインストールファイル：`quasto/src/apex/plugin/region_type_plugin_quasto_region.sql`
- GitHubリポジトリ：https://github.com/mt-ag/quasto
- プラグインはqaru_category = 'APEX'のルールのみを実行
- 推奨使用方法：Global Pageにプラグインリージョンを配置し、開発環境でのみ表示するよう条件設定
- Application ID/Page IDは`&APP_ID.`、`&APP_PAGE_ID.`で動的に取得可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プラグインが使用するデータ型とルール定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules テーブル定義 | （DDL未確認） | qaru_id, qaru_rule_number, qaru_client_name, qaru_category, qaru_sql等のカラム構成 |
| 1-2 | qa_rules_t 型定義 | （TYPE定義未確認） | プラグインが返却するオブジェクト型の構造 |

**読解のコツ**: QUASTOはqa_rules_t（コレクション型）を使用してルール実行結果を返却する。各要素にはqaru_error_level, object_type, object_name, object_details等が含まれる。

#### Step 2: エントリーポイントを理解する

画面定義ファイルでUI構成とプラグイン呼び出しを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00020.sql | `src/apex/f141/application/pages/page_00020.sql` | Select List定義、プラグインリージョン定義、カスケードLOV設定 |

**主要処理フロー**:
1. **行14-23**: ページ基本定義
2. **行63-79**: QUASTO Region Plugin Demoリージョン（PLUGIN_QUASTO_REGION）
3. **行80-101**: P20_APP_ID Select List定義（Application LOV）
4. **行102-125**: P20_APP_PAGE_ID Select List定義（カスケードLOV）
5. **行126-145**: P20_CLIENT_NAME Select List定義
6. **行146-170**: P20_RULE_SELECTION Select List定義（カスケードLOV）

#### Step 3: プラグインの実装を理解する

プラグインのレンダリング処理とルール実行ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | region_type_plugin_quasto_region.sql | `src/apex/plugin/region_type_plugin_quasto_region.sql` | render_qa_region関数、HTMLテーブル生成、qa_apex_api_pkg呼び出し |

**主要処理フロー**:
- **行61-166**: render_qa_region関数
- **行86-116**: HTMLヘッダー/フッター生成関数
- **行118-138**: 個別行のHTML生成関数
- **行167-191**: メイン処理（tf_run_rules呼び出し、結果のHTML出力）

#### Step 4: ビジネスロジックを理解する

APEXルール実行のコアロジックを含むパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | tf_run_rules関数、tf_run_rule関数、ルールSQL実行 |

**主要処理フロー**:
- **行28-35**: tf_run_rules関数定義（複数ルール実行）
- **行99-182**: tf_run_rule関数（単一ルール実行、動的SQL実行）
- **行41-96**: p_exclude_not_whitelisted_apex_entries（ブラックリスト除外処理）

### プログラム呼び出し階層図

```
[Page 20: Region Plugin画面]
    │
    ├─ [QUASTO Region Plugin Demo]
    │      │
    │      └─ [PLUGIN_QUASTO_REGION]
    │             │
    │             └─ render_qa_region (プラグインPL/SQL)
    │                    │
    │                    ├─ get_html_region_header
    │                    │
    │                    ├─ qa_apex_api_pkg.tf_run_rules
    │                    │      │
    │                    │      └─ tf_run_rule (ルールごとにループ)
    │                    │             │
    │                    │             ├─ qa_main_pkg.f_is_rule_active
    │                    │             │
    │                    │             ├─ qa_main_pkg.f_get_rule
    │                    │             │
    │                    │             ├─ EXECUTE IMMEDIATE (qaru_sql)
    │                    │             │
    │                    │             └─ p_exclude_not_whitelisted_apex_entries
    │                    │
    │                    ├─ get_html_rule_line (各違反オブジェクトをHTML化)
    │                    │
    │                    └─ get_html_region_footer
    │
    ├─ [P20_CLIENT_NAME LOV]
    │      │
    │      └─ SELECT FROM qa_rules WHERE qaru_category = 'APEX'
    │
    ├─ [P20_RULE_SELECTION LOV]
    │      │
    │      └─ SELECT FROM qa_rules
    │            WHERE qaru_category = 'APEX'
    │            AND (qaru_client_name = :P20_CLIENT_NAME OR :P20_CLIENT_NAME IS NULL)
    │
    ├─ [P20_APP_ID LOV]
    │      │
    │      └─ SELECT FROM apex_applications WHERE workspace != 'INTERNAL'
    │
    └─ [P20_APP_PAGE_ID LOV]
           │
           └─ SELECT FROM apex_application_pages
                 WHERE (:P20_APP_ID = application_id OR :P20_APP_ID IS NULL)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

P20_CLIENT_NAME    ───┐
                     │
P20_RULE_SELECTION ───┼──▶ render_qa_region
                     │         │
P20_APP_ID        ───┤         ▼
                     │   qa_apex_api_pkg.tf_run_rules
P20_APP_PAGE_ID   ───┘         │
                               ▼
                         [QA_RULES から SQL取得]
                               │
                               ▼
                         [EXECUTE IMMEDIATE]
                               │
                               ├──▶ APEX_APPLICATION_ITEMS
                               ├──▶ APEX_APPLICATION_PAGES
                               └──▶ APEX_APPLICATION_PAGE_REGIONS
                                    (etc. APEXメタデータ)
                               │
                               ▼
                         [qa_rules_t コレクション]
                               │
                               ▼
                         [HTMLテーブル生成]
                               │
                               ▼
                         [Plugin Region 表示]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00020.sql | `src/apex/f141/application/pages/page_00020.sql` | ソース | 画面定義（APEX Page） |
| region_type_plugin_quasto_region.sql | `src/apex/plugin/region_type_plugin_quasto_region.sql` | ソース | プラグイン定義・レンダリング関数 |
| qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | ソース | APEXルール実行ロジック |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | ルール取得・検証コアロジック |
| main.css | （プラグイン内包） | スタイル | テーブル表示用CSS |
